//////////////////////
//Created by KyleMan//
//////////////////////

using System;
using Server;

namespace Server.Items
{
	public class NobleSword : Longsword
	{
	 	public override int ArtifactRarity{ get{ return 90; } }
	 	public override int InitMinHits{ get{ return 125; } }
	 	public override int InitMaxHits{ get{ return 125; } }
	 	[Constructable]
	 	public NobleSword()
	 	{
	 	 	Name = "Noble Sword";
	 	 	Hue = 1259;
	 	 	Attributes.SpellChanneling = 1;
	 	 	Attributes.BonusHits = 10;
	 	 	Attributes.RegenHits = 3;
	 	 	Attributes.AttackChance = 20;
	 	 	Attributes.WeaponDamage = 50;
	 	 	Attributes.WeaponSpeed = 25;
	 	 	//WeaponAttributes.HitFireArea = 40;
	 	 	WeaponAttributes.ResistFireBonus = 20;
	 	 	WeaponAttributes.HitFireball = 50;
	 	}

	 	public NobleSword(Serial serial) : base( serial )
	 	{
	 	}

	 	public override void Serialize( GenericWriter writer )
	 	{
	 	 	base.Serialize( writer );

	 	 	writer.Write( (int) 0 );
	 	}
	 	public override void Deserialize(GenericReader reader)
	 	{
	 	 	base.Deserialize( reader );

	 	 	int version = reader.ReadInt();
	 	}
	}
}
